#ifndef MDSS_R69006_H
#define MDSS_R69006_H
#include "lcd_interface.h"
#include "mdss_panel.h"

/*********************************** head cmd *************************************/
static char r69006_addr_mode[] = {0xB0,0x00};
static char r69006_pixel_format[] = {0xB3,0x04,0x10,0x00,0x00,0x00};
static char r69006_mcs_protect_off[]      = {0xB4,0x0C,0x00};
static char r69006_dis_ctrl[]      = {0xB6,0x3B,0xD3,0x00};
static char r69006_nop_command[]          = {0x00};

static struct dsi_cmd_desc r69006_packet_head_cmds[] = {
	{{0x23, 1, 0, 0, 0, sizeof(r69006_addr_mode)}, r69006_addr_mode},
	{{0x29, 1, 0, 0, 0, sizeof(r69006_pixel_format)}, r69006_pixel_format},
	{{0x29, 1, 0, 0, 0, sizeof(r69006_mcs_protect_off)}, r69006_mcs_protect_off},
	{{0x29, 1, 0, 0, 0, sizeof(r69006_dis_ctrl)}, r69006_dis_ctrl},
	{{DTYPE_DCS_WRITE, 1, 0, 0, 0, sizeof(r69006_nop_command)}, r69006_nop_command},
};
/*********************************** ce *************************************/
static char r69006_ce0[]={0xCA,0x01,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x60,0xCE,0x70,0xD1,0x42,0x44,0x80,0x69,0xDA,0x08,0x08,0x08,0x06,0x08,0x04,0x00,0x00,0x10,0x10,0x3F,0x3F,0x3F,0x3F};
static char r69006_ce1[]={0xCA,0x01,0x80,0xD0,0xD0,0xD0,0xD0,0xD0,0xD0,0x03,0x60,0xCE,0x70,0xD1,0x42,0x44,0x80,0x69,0xDA,0x08,0x08,0x08,0x06,0x08,0x04,0x00,0x00,0x10,0x10,0x3F,0x3F,0x3F,0x3F};
static char r69006_ce2[]={0xCA,0x01,0x80,0xD0,0xD0,0xD0,0xD0,0xD0,0xD0,0x05,0x60,0xCE,0x70,0xD1,0x42,0x44,0x80,0x69,0xDA,0x08,0x08,0x08,0x06,0x08,0x04,0x00,0x00,0x10,0x10,0x3F,0x3F,0x3F,0x3F};
static char r69006_ce3[]={0xCA,0x01,0x80,0xD0,0xD0,0xD0,0xD0,0xD0,0xD0,0x08,0x60,0xCE,0x70,0xD1,0x42,0x44,0x80,0x69,0xDA,0x08,0x08,0x08,0x06,0x08,0x04,0x00,0x00,0x10,0x10,0x3F,0x3F,0x3F,0x3F};
static char r69006_ce4[]={0xCA,0x01,0x80,0xD0,0xD0,0xD0,0xD0,0xD0,0xD0,0x0A,0x60,0xCE,0x70,0xD1,0x42,0x44,0x80,0x69,0xDA,0x08,0x08,0x08,0x06,0x08,0x04,0x00,0x00,0x10,0x10,0x3F,0x3F,0x3F,0x3F};
static char r69006_ce5[]={0xCA,0x01,0x80,0xD0,0xD0,0xD0,0xD0,0xD0,0xD0,0x0C,0x60,0xCE,0x70,0xD1,0x42,0x44,0x80,0x69,0xDA,0x08,0x08,0x08,0x06,0x08,0x04,0x00,0x00,0x10,0x10,0x3F,0x3F,0x3F,0x3F};
static char r69006_ce6[]={0xCA,0x01,0x80,0xD0,0xD0,0xD0,0xD0,0xD0,0xD0,0x0D,0x60,0xCE,0x70,0xD1,0x42,0x44,0x80,0x69,0xDA,0x08,0x08,0x08,0x06,0x08,0x04,0x00,0x00,0x10,0x10,0x3F,0x3F,0x3F,0x3F};
static char r69006_ce7[]={0xCA,0x01,0x80,0xD0,0xD0,0xD0,0xD0,0xD0,0xD0,0x0E,0x60,0xCE,0x70,0xD1,0x42,0x44,0x80,0x69,0xDA,0x08,0x08,0x08,0x06,0x08,0x04,0x00,0x00,0x10,0x10,0x3F,0x3F,0x3F,0x3F};
static char r69006_ce8[]={0xCA,0x01,0x80,0xD0,0xD0,0xD0,0xD0,0xD0,0xD0,0x0F,0x60,0xCE,0x70,0xD1,0x42,0x44,0x80,0x69,0xDA,0x08,0x08,0x08,0x06,0x08,0x04,0x00,0x00,0x10,0x10,0x3F,0x3F,0x3F,0x3F};
static char r69006_ce9[]={0xCA,0x01,0x80,0xD0,0xD0,0xD0,0xD0,0xD0,0xD0,0x10,0x60,0xCE,0x70,0xD1,0x42,0x44,0x80,0x69,0xDA,0x08,0x08,0x08,0x06,0x08,0x04,0x00,0x00,0x10,0x10,0x3F,0x3F,0x3F,0x3F};
#if 0
static char r69006_ce10[]={0xCA,0x01,0x80,0x80,0x8E,0xA0,0xA0,0xA0,0x8E,0x06,0x20,0x00,0x80,0xD1,0x42,0x44,0x80,0x69,0xDA,0x08,0x08,0x08,0x06,0x08,0x04,0x00,0x00,0x10,0x10,0x3F,0x3F,0x3F,0x3F};
static char r69006_ce11[] = {0xca,0x01,0x99,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce12[] = {0xca,0x01,0x9E,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce13[] = {0xca,0x01,0x9E,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce14[] = {0xca,0x01,0xA3,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce15[] = {0xca,0x01,0xA3,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce16[] = {0xca,0x01,0xA8,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce17[] = {0xca,0x01,0xA8,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce18[] = {0xca,0x01,0xAD,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce19[] = {0xca,0x01,0xAD,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce20[] = {0xca,0x01,0xB2,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce21[] = {0xca,0x01,0xB2,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce22[] = {0xca,0x01,0xB7,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce23[] = {0xca,0x01,0xB7,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce24[] = {0xca,0x01,0xBC,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce25[] = {0xca,0x01,0xBC,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce26[] = {0xca,0x01,0xC1,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce27[] = {0xca,0x01,0xC1,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce28[] = {0xca,0x01,0xC5,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce29[] = {0xca,0x01,0xC5,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce30[] = {0xca,0x01,0xC8,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
static char r69006_ce31[] = {0xca,0x01,0xC8,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
#endif

char *r69006_ce[] = {
	r69006_ce0,
	r69006_ce1,
	r69006_ce2,
	r69006_ce3,
	r69006_ce4,
	r69006_ce5,
	r69006_ce6,
	r69006_ce7,
	r69006_ce8,
	r69006_ce9,
#if 0
	r69006_ce10,
	r69006_ce11,
	r69006_ce12,
	r69006_ce13,
	r69006_ce14,
	r69006_ce15,
	r69006_ce16,
	r69006_ce17,
	r69006_ce18,
	r69006_ce19,
	r69006_ce20,
	r69006_ce21,
	r69006_ce22,
	r69006_ce23,
	r69006_ce24,
	r69006_ce25,
	r69006_ce26,
	r69006_ce27,
	r69006_ce28,
	r69006_ce29,
	r69006_ce30,
	r69006_ce31,
#endif
};

static struct dsi_cmd_desc r69006_effect_ce[] = {
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(r69006_ce0)}, r69006_ce0},
};

struct lcd_effect_cmds r69006_effect_ce_cmd[] = {
	{{r69006_ce, ARRAY_SIZE(r69006_ce)}, {r69006_effect_ce, ARRAY_SIZE(r69006_effect_ce)}},
};
/*********************************** cta *************************************/
static char r69006_cta0[]  = {0xC8,0x01,0x00,0x0A,0x05,0x03,0xFC,0x00,0x00,0x05,0x05,0xFC,0x99,0x00,0x00,0xFB,0x08,0xF7,0x1C,0x00};
static char r69006_cta1[]  = {0xC8,0x01,0x00,0x0A,0x05,0x03,0xFC,0x00,0x00,0x05,0x05,0xFC,0x99,0x00,0x00,0xFB,0x08,0xF7,0x1C,0x00};
static char r69006_cta2[]  = {0xC8,0x01,0x00,0x0A,0x05,0x03,0xFC,0x00,0x00,0x05,0x05,0xFB,0xA9,0x00,0x00,0xFD,0x07,0xF8,0x3E,0x00};
static char r69006_cta3[]  = {0xC8,0x01,0x00,0x0A,0x05,0x03,0xFC,0x00,0x00,0x05,0x05,0xFB,0xA9,0x00,0x00,0xFD,0x07,0xF8,0x3E,0x00};
static char r69006_cta4[]  = {0xC8,0x01,0x00,0x09,0x05,0x03,0xFC,0x00,0x00,0x04,0x04,0xFB,0xB5,0x00,0x00,0xFE,0x06,0xF9,0x5A,0x00};
static char r69006_cta5[]  = {0xC8,0x01,0x00,0x09,0x05,0x03,0xFC,0x00,0x00,0x04,0x04,0xFB,0xB5,0x00,0x00,0xFE,0x06,0xF9,0x5A,0x00};
static char r69006_cta6[]  = {0xC8,0x01,0x00,0x08,0x05,0x03,0xFC,0x00,0x00,0x04,0x04,0xFB,0xC1,0x00,0x00,0xFE,0x05,0xFA,0x78,0x00};
static char r69006_cta7[]  = {0xC8,0x01,0x00,0x08,0x05,0x03,0xFC,0x00,0x00,0x04,0x04,0xFB,0xC1,0x00,0x00,0xFE,0x05,0xFA,0x78,0x00};
static char r69006_cta8[]  = {0xC8,0x01,0x00,0x08,0x04,0x04,0xFC,0x00,0x00,0x04,0x04,0xFE,0xCB,0x00,0x00,0xFF,0x04,0xFA,0x97,0x00};
static char r69006_cta9[]  = {0xC8,0x01,0x00,0x08,0x04,0x04,0xFC,0x00,0x00,0x04,0x04,0xFE,0xCB,0x00,0x00,0xFF,0x04,0xFA,0x97,0x00};
static char r69006_cta10[]  = {0xC8,0x01,0x00,0x08,0x04,0x04,0xFC,0x00,0x00,0x04,0x05,0x01,0xD4,0x00,0x00,0x00,0x03,0xF8,0xB7,0x00};
static char r69006_cta11[]  = {0xC8,0x01,0x00,0x08,0x04,0x04,0xFC,0x00,0x00,0x04,0x05,0x01,0xD4,0x00,0x00,0x00,0x03,0xF8,0xB7,0x00};
static char r69006_cta12[]  = {0xC8,0x01,0x00,0x07,0x04,0x04,0xFC,0x00,0x00,0x04,0x05,0x02,0xDB,0x00,0x00,0x01,0x02,0xFD,0xCB,0x00};
static char r69006_cta13[]  = {0xC8,0x01,0x00,0x07,0x04,0x04,0xFC,0x00,0x00,0x04,0x05,0x02,0xDB,0x00,0x00,0x01,0x02,0xFD,0xCB,0x00};
static char r69006_cta14[]  = {0xC8,0x01,0x00,0x06,0x04,0x04,0xFC,0x00,0x00,0x04,0x05,0x03,0xE2,0x00,0x00,0x01,0x03,0x00,0xDE,0x00};
static char r69006_cta15[]  = {0xC8,0x01,0x00,0x06,0x04,0x04,0xFC,0x00,0x00,0x04,0x05,0x03,0xE2,0x00,0x00,0x01,0x03,0x00,0xDE,0x00};
static char r69006_cta16[]  = {0xC8,0x01,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00};
//static char r69006_cta8[]  = {0xC8,0x01,0x00,0x05,0x02,0x06,0xF3,0x00,0x00,0x05,0x00,0x00,0xFC,0x00,0x00,0x02,0x03,0x02,0x9E,0x00};
static char r69006_cta17[]  = {0xC8,0x01,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00};
static char r69006_cta18[]  = {0xC8,0x01,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00};
static char r69006_cta19[]  = {0xC8,0x01,0x00,0x06,0x04,0x03,0xF3,0x00,0x00,0x03,0x05,0x05,0xE8,0x00,0x00,0x02,0x04,0x05,0xfC,0x00};
static char r69006_cta20[]  = {0xC8,0x01,0x00,0x06,0x04,0x03,0xF3,0x00,0x00,0x03,0x05,0x05,0xE8,0x00,0x00,0x02,0x04,0x05,0xfC,0x00};
static char r69006_cta21[] = {0xC8,0x01,0x00,0x06,0x04,0x03,0xE6,0x00,0x00,0x03,0x05,0x03,0xDF,0x00,0x00,0x02,0x04,0x05,0xfc,0x00};
static char r69006_cta22[] = {0xC8,0x01,0x00,0x06,0x04,0x03,0xE6,0x00,0x00,0x03,0x05,0x03,0xDF,0x00,0x00,0x02,0x04,0x05,0xfc,0x00};
static char r69006_cta23[] = {0xC8,0x01,0x00,0x05,0x04,0x02,0xD9,0x00,0x00,0x03,0x04,0x02,0xD5,0x00,0x00,0x02,0x04,0x05,0xfc,0x00};
static char r69006_cta24[] = {0xC8,0x01,0x00,0x05,0x04,0x02,0xD9,0x00,0x00,0x03,0x04,0x02,0xD5,0x00,0x00,0x02,0x04,0x05,0xfc,0x00};
static char r69006_cta25[] = {0xC8,0x01,0x00,0x04,0x04,0x00,0xCD,0x00,0x00,0x02,0x04,0xFF,0xCC,0x00,0x00,0x02,0x04,0x05,0xfc,0x00};
static char r69006_cta26[] = {0xC8,0x01,0x00,0x04,0x04,0x00,0xCD,0x00,0x00,0x02,0x04,0xFF,0xCC,0x00,0x00,0x02,0x04,0x05,0xfc,0x00};
static char r69006_cta27[] = {0xC8,0x01,0x00,0x04,0x04,0xFD,0xC2,0x00,0x00,0x02,0x04,0xFC,0xC3,0x00,0x00,0x02,0x04,0x05,0xfc,0x00};
static char r69006_cta28[] = {0xC8,0x01,0x00,0x04,0x04,0xFD,0xC2,0x00,0x00,0x02,0x04,0xFC,0xC3,0x00,0x00,0x02,0x04,0x05,0xfc,0x00};
static char r69006_cta29[] = {0xC8,0x01,0x00,0x04,0x04,0xFD,0xB5,0x00,0x00,0x02,0x04,0xFA,0xB9,0x00,0x00,0x02,0x04,0x05,0xfc,0x00};
static char r69006_cta30[] = {0xC8,0x01,0x00,0x04,0x04,0xFD,0xB5,0x00,0x00,0x02,0x04,0xFA,0xB9,0x00,0x00,0x02,0x04,0x05,0xfc,0x00};
static char r69006_cta31[] = {0xC8,0x01,0x00,0x03,0x05,0xFD,0xA5,0x00,0x00,0x01,0x05,0xFB,0xAA,0x00,0x00,0x02,0x04,0x05,0xfc,0x00};
static char r69006_cta32[] = {0xC8,0x01,0x00,0x03,0x05,0xFD,0xA5,0x00,0x00,0x01,0x05,0xFB,0xAA,0x00,0x00,0x02,0x04,0x05,0xfc,0x00};

#if 0
static char r69006_cta16[] = {0xC8,0x01,0x00,0x03,0x02,0x03,0xD5,0x00,0x00,0x03,0x00,0xFD,0xFC,0x00,0x00,0x02,0x04,0x05,0xDB,0x00};
static char r69006_cta17[] = {0xC8,0x01,0x00,0x03,0x02,0x03,0xD4,0x00,0x00,0x03,0x00,0xFD,0xFC,0x00,0x00,0x02,0x04,0x05,0xE3,0x00};
static char r69006_cta18[] = {0xC8,0x01,0x00,0x03,0x02,0x05,0xD2,0x00,0x00,0x03,0x00,0xFD,0xFC,0x00,0x00,0x02,0x05,0x05,0xEA,0x00};
static char r69006_cta19[] = {0xC8,0x01,0x00,0x03,0x02,0x04,0xD1,0x00,0x00,0x03,0x00,0xFD,0xFC,0x00,0x00,0x00,0x05,0x06,0xF1,0x00};
static char r69006_cta20[] = {0xC8,0x01,0x00,0x02,0x02,0x04,0xD0,0x00,0x00,0x03,0x00,0xFD,0xFC,0x00,0x00,0x02,0x04,0x06,0xF7,0x00};
static char r69006_cta21[] = {0xC8,0x01,0x00,0x02,0x02,0x04,0xCE,0x00,0x00,0x03,0x00,0x00,0xFA,0x00,0x00,0x01,0x05,0x05,0xFC,0x00};
static char r69006_cta22[] = {0xC8,0x01,0x00,0x02,0x02,0x03,0xC7,0x00,0x00,0x04,0x00,0x00,0xF3,0x00,0x00,0x01,0x05,0x05,0xFC,0x00};
static char r69006_cta23[] = {0xC8,0x01,0x00,0x03,0x01,0x03,0xC1,0x00,0x00,0x03,0x00,0xFF,0xED,0x00,0x00,0x01,0x05,0x05,0xFC,0x00};
static char r69006_cta24[] = {0xC8,0x01,0x00,0x03,0x01,0x03,0xBB,0x00,0x00,0x03,0x00,0x00,0xE7,0x00,0x00,0x01,0x05,0x05,0xFC,0x00};
static char r69006_cta25[] = {0xC8,0x01,0x00,0x01,0x02,0x02,0xB4,0x00,0x00,0x03,0x00,0xFF,0xE1,0x00,0x00,0x01,0x05,0x05,0xFC,0x00};
static char r69006_cta26[] = {0xC8,0x01,0x00,0x03,0x01,0x03,0xAE,0x00,0x00,0x03,0x00,0x00,0xDB,0x00,0x00,0x01,0x05,0x05,0xFC,0x00};
static char r69006_cta27[] = {0xC8,0x01,0x00,0x02,0x01,0x01,0xA9,0x00,0x00,0x03,0x00,0x00,0xD7,0x00,0x00,0x01,0x05,0x05,0xFC,0x00};
static char r69006_cta28[] = {0xC8,0x01,0x00,0x02,0x01,0x01,0xA4,0x00,0x00,0x03,0x00,0x00,0xD3,0x00,0x00,0x01,0x05,0x05,0xFC,0x00};
static char r69006_cta29[] = {0xC8,0x01,0x00,0x02,0x01,0x01,0x9F,0x00,0x00,0x03,0x00,0x00,0xD0,0x00,0x00,0x01,0x05,0x05,0xFC,0x00};
static char r69006_cta30[] = {0xC8,0x01,0x00,0x02,0x01,0x01,0x99,0x00,0x00,0x03,0x00,0x00,0xCC,0x00,0x00,0x01,0x05,0x05,0xFC,0x00};
static char r69006_cta31[] = {0xC8,0x01,0x00,0x02,0x01,0x01,0x94,0x00,0x00,0x03,0x00,0x00,0xC8,0x00,0x00,0x01,0x05,0x05,0xFC,0x00};
static char r69006_cta32[] = {0xC8,0x01,0x00,0x02,0x01,0x02,0x8F,0x00,0x00,0x03,0x00,0x00,0xC5,0x00,0x00,0x01,0x05,0x05,0xFC,0x00};
#endif
char *r69006_cta[] = {
	r69006_cta0,
	r69006_cta1,
	r69006_cta2,
	r69006_cta3,
	r69006_cta4,
	r69006_cta5,
	r69006_cta6,
	r69006_cta7,
	r69006_cta8,
	r69006_cta9,
	r69006_cta10,
	r69006_cta11,
	r69006_cta12,
	r69006_cta13,
	r69006_cta14,
	r69006_cta15,
#if 1
	r69006_cta16,
	r69006_cta17,
	r69006_cta18,
	r69006_cta19,
	r69006_cta20,
	r69006_cta21,
	r69006_cta22,
	r69006_cta23,
	r69006_cta24,
	r69006_cta25,
	r69006_cta26,
	r69006_cta27,
	r69006_cta28,
	r69006_cta29,
	r69006_cta30,
	r69006_cta31,
	r69006_cta32,
#endif
};

static struct dsi_cmd_desc r69006_effect_cta[] = {
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(r69006_cta0)}, r69006_cta0},
};
struct lcd_effect_cmds r69006_effect_cta_cmd[] = {
	{{r69006_cta, ARRAY_SIZE(r69006_cta)}, {r69006_effect_cta, ARRAY_SIZE(r69006_effect_cta)}},
};
/************************************ cabc ***********************************/
static char r69006_cabc0[] = {0x55, 0x00};
static char r69006_cabc1[] = {0x55, 0x01};
static char r69006_cabc2[] = {0x55, 0x02};
static char r69006_cabc3[] = {0x55, 0x03};
static char r69006_cabc4[] = {0x55, 0x73};

char *r69006_cabc[] = {
	r69006_cabc0,
	r69006_cabc1,
	r69006_cabc2,
	r69006_cabc3,
	r69006_cabc4,
};

static char r69006_blc0[] = {0xb8,0x00,0x00,0x00,0x00,0x00,0x00};
static char r69006_blc1[] = {0xb8,0x07,0x75,0x61,0x20,0x16,0x87};
static char r69006_blc2[] = {0xb9,0x07,0x75,0x61,0x20,0x16,0x87};
static char r69006_blc3[] = {0xba,0x07,0x75,0x61,0x20,0x16,0x87};
static char r69006_blc4[] = {0xba,0x05,0x3c,0xff,0x00,0x00,0x00};

static char *r69006_blc[] = {
	r69006_blc0,
	r69006_blc1,
	r69006_blc2,
	r69006_blc3,
	r69006_blc4,
};

static struct dsi_cmd_desc r69006_effect_blc[] = {
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(r69006_blc0)}, r69006_blc0},
};

static struct dsi_cmd_desc r69006_effect_cabc[] = {
	{{DTYPE_DCS_WRITE1, 1, 0, 0, 0, sizeof(r69006_cabc0)}, r69006_cabc0},
};
struct lcd_effect_cmds r69006_effect_cabc_cmd[] = {
	{{r69006_blc, ARRAY_SIZE(r69006_blc)}, {r69006_effect_blc, ARRAY_SIZE(r69006_effect_blc)}},
	{{r69006_cabc, ARRAY_SIZE(r69006_cabc)}, {r69006_effect_cabc, ARRAY_SIZE(r69006_effect_cabc)}},
};
/*************************************  aco ***********************************/
#if 0
static char r69006_aco0[] = {0xba,0x07,0xb0,0x00,0x00,0x00,0x87};
static char r69006_aco1[] = {0xba,0x07,0xb0,0x00,0x00,0x00,0x87};
static char r69006_aco2[] = {0xba,0x07,0xa3,0x10,0x04,0x10,0x87};
static char r69006_aco3[] = {0xba,0x07,0xa3,0x10,0x04,0x10,0x87};
static char r69006_aco4[] = {0xba,0x07,0xa0,0x16,0x06,0x16,0x87};
static char r69006_aco5[] = {0xba,0x07,0xa0,0x16,0x06,0x16,0x87};
static char r69006_aco6[] = {0xba,0x07,0x9c,0x1c,0x08,0x1c,0x87};
static char r69006_aco7[] = {0xba,0x07,0x9c,0x1c,0x08,0x1c,0x87};
static char r69006_aco8[] = {0xba,0x07,0x99,0x22,0x0a,0x22,0x87};
static char r69006_aco9[] = {0xba,0x07,0x99,0x22,0x0a,0x22,0x87};
static char r69006_aco10[] = {0xba,0x07,0x96,0x28,0x0c,0x28,0x87};
static char r69006_aco11[] = {0xba,0x07,0x96,0x28,0x0c,0x28,0x87};
static char r69006_aco12[] = {0xba,0x07,0x93,0x2e,0x0e,0x2e,0x87};
static char r69006_aco13[] = {0xba,0x07,0x93,0x2e,0x0e,0x2e,0x87};
static char r69006_aco14[] = {0xba,0x07,0x90,0x34,0x10,0x34,0x87};
static char r69006_aco15[] = {0xba,0x07,0x90,0x34,0x10,0x34,0x87};
static char r69006_aco16[] = {0xba,0x07,0x8d,0x3a,0x12,0x3a,0x87};
static char r69006_aco17[] = {0xba,0x07,0x8d,0x3a,0x12,0x3a,0x87};
static char r69006_aco18[] = {0xba,0x07,0x8a,0x40,0x15,0x40,0x87};
static char r69006_aco19[] = {0xba,0x07,0x8a,0x40,0x15,0x40,0x87};
static char r69006_aco20[] = {0xba,0x07,0x87,0x46,0x18,0x46,0x87};
static char r69006_aco21[] = {0xba,0x07,0x87,0x46,0x18,0x46,0x87};
static char r69006_aco22[] = {0xba,0x07,0x84,0x4c,0x1b,0x4c,0x87};
static char r69006_aco23[] = {0xba,0x07,0x84,0x4c,0x1b,0x4c,0x87};
static char r69006_aco24[] = {0xba,0x07,0x81,0x52,0x1e,0x52,0x87};
static char r69006_aco25[] = {0xba,0x07,0x81,0x52,0x1e,0x52,0x87};
static char r69006_aco26[] = {0xba,0x07,0x7e,0x58,0x27,0x58,0x87};
static char r69006_aco27[] = {0xba,0x07,0x7e,0x58,0x27,0x58,0x87};
static char r69006_aco28[] = {0xba,0x07,0x78,0x64,0x30,0x64,0x87};
static char r69006_aco29[] = {0xba,0x07,0x78,0x64,0x30,0x64,0x87};
static char r69006_aco30[] = {0xba,0x07,0x70,0x70,0x3a,0x70,0x87};
static char r69006_aco31[] = {0xba,0x07,0x70,0x70,0x3a,0x70,0x87};

static char *r69006_aco[] = {
	r69006_aco0,
	r69006_aco1,
	r69006_aco2,
	r69006_aco3,
	r69006_aco4,
	r69006_aco5,
	r69006_aco6,
	r69006_aco7,
	r69006_aco8,
	r69006_aco9,
	r69006_aco10,
	r69006_aco11,
	r69006_aco12,
	r69006_aco13,
	r69006_aco14,
	r69006_aco15,
	r69006_aco16,
	r69006_aco17,
	r69006_aco18,
	r69006_aco19,
	r69006_aco20,
	r69006_aco21,
	r69006_aco22,
	r69006_aco23,
	r69006_aco24,
	r69006_aco25,
	r69006_aco26,
	r69006_aco27,
	r69006_aco28,
	r69006_aco29,
	r69006_aco30,
	r69006_aco31,
};
static char *r69006_aco_blc[] = {
	r69006_blc1,
};
#endif
#if 0
static char r69006_aco_cabc0[] = {0x55,0x03};
static char *r69006_aco_cabc[] = {
	r69006_aco_cabc0,
};
static struct dsi_cmd_desc r69006_effect_aco_blc[] = {
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(r69006_blc1)}, r69006_blc1},
};

static struct dsi_cmd_desc r69006_effect_aco_cabc[] = {
	{{DTYPE_DCS_WRITE1, 1, 0, 0, 0, sizeof(r69006_aco_cabc0)}, r69006_aco_cabc0},
};

static struct dsi_cmd_desc r69006_effect_aco[] = {
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(r69006_aco0)}, r69006_aco0},
};

struct lcd_effect_cmds r69006_effect_aco_cmd[] = {
	//{{r69006_aco_blc, ARRAY_SIZE(r69006_aco_blc)}, {r69006_effect_aco_blc, ARRAY_SIZE(r69006_effect_aco_blc)}},
	{{r69006_aco_cabc, ARRAY_SIZE(r69006_aco_cabc)}, {r69006_effect_aco_cabc, ARRAY_SIZE(r69006_effect_aco_cabc)}},
	{{r69006_aco, ARRAY_SIZE(r69006_aco)}, {r69006_effect_aco, ARRAY_SIZE(r69006_effect_aco)}},
};
#endif

/************************************* cr ***********************************/
#if 0
static char r69006_cr0[] = {0x00,0x00,0x00,0x00};
static char r69006_cr1[] = {0xbb,0x00,0x00,0x00};
static char r69006_cr2[] = {0xbb,0x00,0x00,0x08};
static char r69006_cr3[] = {0xbb,0x00,0x00,0x10};
static char r69006_cr4[] = {0xbb,0x00,0x00,0x18};
static char r69006_cr5[] = {0xbb,0x00,0x00,0x20};
static char r69006_cr6[] = {0xbb,0x00,0x00,0x28};
static char r69006_cr7[] = {0xbb,0x00,0x00,0x30};
static char r69006_cr8[] = {0xbb,0x00,0x00,0x38};
static char r69006_cr9[] = {0xbb,0x00,0x00,0x40};
static char r69006_cr10[] = {0xbb,0x00,0x00,0x48};
static char r69006_cr11[] = {0xbb,0x00,0x00,0x50};
static char r69006_cr12[] = {0xbb,0x00,0x00,0x58};
static char r69006_cr13[] = {0xbb,0x00,0x00,0x60};
static char r69006_cr14[] = {0xbb,0x00,0x00,0x68};
static char r69006_cr15[] = {0xbb,0x00,0x00,0x70};

char *r69006_cr[] = {
	r69006_cr0,
	r69006_cr1,
	r69006_cr2,
	r69006_cr3,
	r69006_cr4,
	r69006_cr5,
	r69006_cr6,
	r69006_cr7,
	r69006_cr8,
	r69006_cr9,
	r69006_cr10,
	r69006_cr11,
	r69006_cr12,
	r69006_cr13,
	r69006_cr14,
	r69006_cr15,
};
static char r69006_cr_cabc0[] = {0x55, 0x00};
static char *r69006_cr_cabc[] = {
	r69006_cr_cabc0,
};
static struct dsi_cmd_desc r69006_effect_cr[] = {
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(r69006_cr0)}, r69006_cr0},
};
static struct dsi_cmd_desc r69006_effect_cr_cabc[] = {
	{{DTYPE_DCS_WRITE1, 1, 0, 0, 0, sizeof(r69006_cr_cabc0)}, r69006_cr_cabc0},
};


struct lcd_effect_cmds r69006_effect_cr_cmd[] = {
	{{r69006_cr, ARRAY_SIZE(r69006_cr)}, {r69006_effect_cr, ARRAY_SIZE(r69006_effect_cr)}},
	{{r69006_cr_cabc, ARRAY_SIZE(r69006_cr_cabc)}, {r69006_effect_cr_cabc, ARRAY_SIZE(r69006_effect_cr_cabc)}},
};

/************************************* sre ***********************************/
static char r69006_sre0[]={0x00,0x00,0x00,0x00};
static char r69006_sre1[]={0xbb,0x00,0x1f,0x00};
static char r69006_sre2[]={0xbb,0x00,0x2f,0x00};
static char r69006_sre3[]={0xbb,0x00,0x3f,0x00};
static char r69006_sre4[]={0xbb,0x00,0x4f,0x00};
static char r69006_sre5[]={0xbb,0x00,0x5f,0x00};
static char r69006_sre6[]={0xbb,0x00,0x6f,0x00};
static char r69006_sre7[]={0xbb,0x00,0x7f,0x00};
static char r69006_sre8[]={0xbb,0x00,0x8f,0x00};
static char r69006_sre9[]={0xbb,0x00,0x9f,0x00};
static char r69006_sre10[]={0xbb,0x00,0xaf,0x00};
static char r69006_sre11[]={0xbb,0x00,0xbf,0x00};
static char r69006_sre12[]={0xbb,0x00,0xcf,0x00};
static char r69006_sre13[]={0xbb,0x00,0xdf,0x00};
static char r69006_sre14[]={0xbb,0x00,0xef,0x00};
static char r69006_sre15[]={0xbb,0x00,0xff,0x00};

char *r69006_sre[] = {
	r69006_sre0,
	r69006_sre1,
	r69006_sre2,
	r69006_sre3,
	r69006_sre4,
	r69006_sre5,
	r69006_sre6,
	r69006_sre7,
	r69006_sre8,
	r69006_sre9,
	r69006_sre10,
	r69006_sre11,
	r69006_sre12,
	r69006_sre13,
	r69006_sre14,
	r69006_sre15,
};

static char r69006_sre_cabc0[] = {0x00, 0x00};
static char *r69006_sre_cabc[] = {
	r69006_sre_cabc0,
};
static struct dsi_cmd_desc r69006_effect_sre_cabc[] = {
	{{DTYPE_DCS_WRITE1, 1, 0, 0, 0, sizeof(r69006_sre_cabc0)}, r69006_sre_cabc0},
};
static struct dsi_cmd_desc r69006_effect_sre[] = {
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(r69006_sre0)}, r69006_sre0},
};

struct lcd_effect_cmds r69006_effect_sre_cmd[] = {
	{{r69006_sre_cabc, ARRAY_SIZE(r69006_sre_cabc)}, {r69006_effect_sre_cabc, ARRAY_SIZE(r69006_effect_sre_cabc)}},
	{{r69006_sre, ARRAY_SIZE(r69006_sre)}, {r69006_effect_sre, ARRAY_SIZE(r69006_effect_sre)}},
};
#endif
/************************************** picture mode **************************************/
static char picture_mode_cmd0[] = {0x55,0x00};
static char picture_mode_cmd1[] = {0xba,0x07,0x75,0x61,0x20,0x16,0x87};
static char picture_mode_cmd2[]=  {0xCA,0x01,0x80,0xD0,0xD0,0xD0,0xD0,0xD0,0xD0,0x0B,0x60,0xCE,0x70,0xD1,0x42,0x44,0x80,0x69,0xDA,0x08,0x08,0x08,0x06,0x08,0x04,0x00,0x00,0x10,0x10,0x3F,0x3F,0x3F,0x3F};

//static char picture_mode_cmd3[] = {0xc8,0x01,0x00,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0xfc,0x00};
static struct dsi_cmd_desc picture_mode_cmds[] = {
	{{DTYPE_DCS_WRITE1, 1, 0, 0, 0, sizeof(picture_mode_cmd0)}, picture_mode_cmd0},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(picture_mode_cmd1)}, picture_mode_cmd1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(picture_mode_cmd2)}, picture_mode_cmd2},
//	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(picture_mode_cmd3)}, picture_mode_cmd3},
};

/************************************** camera mode **************************************/
static char camera_mode_cmd0[] = {0x55,0x00};
static char camera_mode_cmd1[] = {0xba,0x07,0x75,0x61,0x20,0x16,0x87};
static char camera_mode_cmd2[]=  {0xCA,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x10,0x60,0xCE,0x80,0xD1,0x42,0x44,0x80,0x69,0xDA,0x08,0x08,0x08,0x06,0x08,0x04,0x00,0x00,0x10,0x10,0x3F,0x3F,0x3F,0x3F};

//static char picture_mode_cmd3[] = {0xc8,0x01,0x00,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0xfc,0x00};
static struct dsi_cmd_desc camera_mode_cmds[] = {
	{{DTYPE_DCS_WRITE1, 1, 0, 0, 0, sizeof(camera_mode_cmd0)}, camera_mode_cmd0},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(camera_mode_cmd1)}, camera_mode_cmd1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(camera_mode_cmd2)}, camera_mode_cmd2},
//	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(picture_mode_cmd3)}, picture_mode_cmd3},
};

/************************************** comfort mode **************************************/
static char comfort_mode_cmd0[]=  {0xca,0x00,0x80,0xf8,0xf8,0xf8,0xf8,0xf8,0xf8,0x20,0x20,0x20,0x80,0xd1,0x42,0x44,0x80,0x69,0xda,0x08,0x08,0x08,0x06,0x08,0x04,0x00,0x00,0x10,0x10,0x3F,0x3F,0x3F,0x3F};
static char comfort_mode_cmd1[] = {0x55,0x03};
static char comfort_mode_cmd2[] = {0xba,0x07,0x75,0x61,0x20,0x16,0x87};
static char comfort_mode_cmd3[] = {0xC8,0x01,0x9c,0x0A,0x05,0x03,0xFC,0x00,0x9c,0x05,0x05,0xFC,0x99,0x00,0x9c,0xfb,0x08,0xf7,0x1C,0x00};

static struct dsi_cmd_desc comfort_mode_cmds[] = {
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(comfort_mode_cmd0)}, comfort_mode_cmd0},
	{{DTYPE_DCS_WRITE1, 1, 0, 0, 0, sizeof(comfort_mode_cmd1)}, comfort_mode_cmd1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(comfort_mode_cmd2)}, comfort_mode_cmd2},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(comfort_mode_cmd3)}, comfort_mode_cmd3},
};

/************************************** outside mode **************************************/
static char outside_mode_cmd0[] = {0x55,0x73};
//static char outside_mode_cmd1[] = {0xc8,0x01,0x00,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0xfc,0x00};
/*
static char outside_mode_cmd2[] = {0xca,0x01,0xC8,0x80,0x80,0x80,0x80,0x80,0x80,0x12,0x29,0xAC,0x80,0x00,0x4A,0x37,0x80,0x55,0xF8,0x08,0x08,0x08,0x08,0x10,0x10,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10};
*/
static char outside_mode_cmd3[] = {0xba,0x05,0x3c,0xff,0x00,0x00,0x00};
static char outside_mode_cmd4[] = {0xbd,0x01,0x1e,0x14};
static struct dsi_cmd_desc outside_mode_cmds[] = {
	{{DTYPE_DCS_WRITE1, 1, 0, 0, 0, sizeof(outside_mode_cmd0)}, outside_mode_cmd0},
	//{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(outside_mode_cmd1)}, outside_mode_cmd1},
	/*
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(outside_mode_cmd2)}, outside_mode_cmd2},
	*/
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(outside_mode_cmd3)}, outside_mode_cmd3},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(outside_mode_cmd4)}, outside_mode_cmd4},
};

/************************************** custom mode **************************************/
static char custom_mode_cmd0[] = {0x55,0x03};
static char custom_mode_cmd1[] = {0xba,0x07,0x75,0x61,0x20,0x16,0x87};

static struct dsi_cmd_desc custom_mode_cmds[] = {
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(custom_mode_cmd0)}, custom_mode_cmd0},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(custom_mode_cmd1)}, custom_mode_cmd1},
};
/************************************** normal mode **************************************/
static char normal_mode_cmd0[] = {0x55,0x03};
static char normal_mode_cmd1[] = {0xba,0x07,0x75,0x61,0x20,0x16,0x87};
static char normal_mode_cmd2[]=  {0xCA,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x00,0x60,0xCE,0x80,0xD1,0x42,0x44,0x80,0x69,0xDA,0x08,0x08,0x08,0x06,0x08,0x04,0x00,0x00,0x10,0x10,0x3F,0x3F,0x3F,0x3F};
static char normal_mode_cmd3[] = {0xC8,0x01,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00};

static struct dsi_cmd_desc normal_mode_cmds[] = {
	//{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(r69006_aco0)}, r69006_aco0},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(normal_mode_cmd2)}, normal_mode_cmd2},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(normal_mode_cmd3)}, normal_mode_cmd3},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(normal_mode_cmd1)}, normal_mode_cmd1},
	{{DTYPE_DCS_WRITE1, 1, 0, 0, 0, sizeof(normal_mode_cmd0)}, normal_mode_cmd0},
};
/************************************** ultra bright mode **************************************/
static char ultra_mode_cmd0[] = {0x55,0x00};
static char ultra_mode_cmd1[] = {0xb8,0x00,0x00,0x00,0x00,0x00,0x00};
static char ultra_mode_cmd2[] = {0xC8,0x01,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00,0xFC,0x00};

static struct dsi_cmd_desc ultra_mode_cmds[] = {
	{{DTYPE_DCS_WRITE1, 1, 0, 0, 0, sizeof(ultra_mode_cmd0)}, ultra_mode_cmd0},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(ultra_mode_cmd1)}, ultra_mode_cmd1},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(ultra_mode_cmd2)}, ultra_mode_cmd2},
	/*
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(ultra_mode_cmd3)}, ultra_mode_cmd3},
	{{DTYPE_GEN_LWRITE, 1, 0, 0, 0, sizeof(ultra_mode_cmd1)}, ultra_mode_cmd1},
	*/
};

/*********************************** all effect ************************************/

struct lcd_effect r69006_effect[] = {
	{"cabc", ARRAY_SIZE(r69006_cabc), 0, {r69006_effect_cabc_cmd, ARRAY_SIZE(r69006_effect_cabc_cmd)}},
	{"ce", ARRAY_SIZE(r69006_ce), 0, {r69006_effect_ce_cmd, ARRAY_SIZE(r69006_effect_ce_cmd)}},
	{"cta", ARRAY_SIZE(r69006_cta), 16, {r69006_effect_cta_cmd, ARRAY_SIZE(r69006_effect_cta_cmd)}},
//	{"aco", ARRAY_SIZE(r69006_aco), 0, {r69006_effect_aco_cmd, ARRAY_SIZE(r69006_effect_aco_cmd)}},
	//{"gamma", ARRAY_SIZE(r69006_sre), 0, {r69006_effect_sre_cmd, ARRAY_SIZE(r69006_effect_sre_cmd)}},
};
/**************************************************************************************/

/************************************** all mode **************************************/
struct lcd_mode r69006_mode[] = {
	{"custom_mode", {3, 0, 16}, {0, 0, 16},0, 0, {custom_mode_cmds, ARRAY_SIZE(custom_mode_cmds)}},
	{"auto_mode", {0, 0, 0}, {0, 0, 16},0, 0, {normal_mode_cmds, ARRAY_SIZE(normal_mode_cmds)}},
	{"normal_mode", {3, 0, 0}, {0, 0, 16},0, 0 ,{normal_mode_cmds, ARRAY_SIZE(normal_mode_cmds)}},
	{"comfort_mode", {3, 0, 0}, {0, 4, 16},0, 0, {comfort_mode_cmds, ARRAY_SIZE(comfort_mode_cmds)}},
	{"outside_mode", {4, 0, 0}, {0, 4, 16},0, 1, {outside_mode_cmds, ARRAY_SIZE(outside_mode_cmds)}},
	{"ultra_mode", {0, 0, 0}, {0, 4, 16},1, 1, {ultra_mode_cmds, ARRAY_SIZE(ultra_mode_cmds)}},
	{"camera_mode", {0, 0, 0}, {0, 4, 16},0, 0, {camera_mode_cmds, ARRAY_SIZE(camera_mode_cmds)}},
	{"picture_mode", {0, 0, 0},{0, 4, 16}, 0, 1, {picture_mode_cmds, ARRAY_SIZE(picture_mode_cmds)}},
};
/**************************************************************************************/
struct lcd_cmds r69006_head_cmds = 
	{r69006_packet_head_cmds, ARRAY_SIZE(r69006_packet_head_cmds)};

struct lcd_effect_data r69006_effect_data = 
	{r69006_effect, &r69006_head_cmds, ARRAY_SIZE(r69006_effect)};

struct lcd_mode_data r69006_mode_data = 
	{r69006_mode, &r69006_head_cmds, ARRAY_SIZE(r69006_mode), 0};

/**************************************************************************************/
struct effect_policy policy = {
	1, //lcd effect enable
	1, //low bl disable cabc
};
struct panel_effect_data lcd_data = {
	&policy,
	//&r69006_effect_data, 
	//&r69006_mode_data, 
	//&r69006_mode[2],
};

#endif
